/****** Object:  Trigger [TRG_EST_NF_SAI_BLOQ_CLI_INATIVO]    Script Date: 02/02/2015 13:44:09 ******/
IF  EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TRG_EST_NF_SAI_BLOQ_CLI_INATIVO]'))
DROP TRIGGER [dbo].[TRG_EST_NF_SAI_BLOQ_CLI_INATIVO]
GO
GO
CREATE TRIGGER [dbo].[TRG_EST_NF_SAI_BLOQ_CLI_INATIVO] ON [dbo].[EST_NF_SAI] 
FOR INSERT, UPDATE
AS
begin
	IF UPDATE (UUID)
	BEGIN
		RETURN;
	END 
	IF EXISTS 
		(SELECT i.CD_EMP
			FROM         
				INSERTED i 
				INNER JOIN RC_CLI C ON 
				I.CD_EMP	= C.CD_EMP AND
				I.CD_CLI	= C.CD_CLI
				
				INNER JOIN GLB_MOV_OP O ON  
				I.CD_NT_MOV  = O.CD_MOV_OP
				
			WHERE
				I.CD_EMP = 1
				AND O.DEST_ORIG = 0 --Clientes
				AND C.STS_CLI = 1 --Cliente intativo
				)

		Begin
			RAISERROR ('Cliente inativo',16, 1);
			ROLLBACK TRANSACTION;
			RETURN;		
		End
		
		
	IF EXISTS 
		(SELECT i.CD_EMP
			FROM         
				INSERTED i INNER JOIN GLB_MOV_OP ON
				i.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP
			WHERE
				I.CD_EMP = 1
				AND I.STS_NF = 0
				AND i.vlr_nf=0
				AND GLB_MOV_OP.FLAG_MOV_OP_NFE_CPL=0
				AND  GLB_MOV_OP.TP_MOV<>25)

		Begin
			RAISERROR ('Valor do documento nao pode ser zero.',16, 1);
			ROLLBACK TRANSACTION;
			RETURN;		
		End
End


GO


